/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.laf;

import com.quantumdata.laf.QDILookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public class QDIButtonUI
extends BasicButtonUI {
    static QDIButtonUI b = new QDIButtonUI();
    Color background;
    Color foreground;
    Font font;

    public static ComponentUI createUI(JComponent jComponent) {
        return b;
    }

    public void installUI(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.background = UIManager.getColor("Button.background");
        this.foreground = UIManager.getColor("Button.foreground");
        this.font = UIManager.getFont("Button.font");
        if (jComponent.getBackground() == null || jComponent.getBackground() instanceof UIResource) {
            jComponent.setBackground(this.background);
        }
        if (jComponent.getForeground() == null || jComponent.getForeground() instanceof UIResource) {
            jComponent.setForeground(this.foreground);
        }
        super.installListeners(abstractButton);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Paint paint;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, abstractButton.getWidth() - (insets.right + insets.left), abstractButton.getHeight() - (insets.bottom + insets.top));
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        int n = jComponent.getHeight() / 3;
        if (n < 10) {
            n = 10;
        }
        graphics2D.setFont(new Font(this.font.getName(), this.font.getStyle(), n));
        String string = SwingUtilities.layoutCompoundLabel(jComponent, graphics2D.getFontMetrics(), abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        BufferedImage bufferedImage = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        Color color = jComponent.getBackground();
        Color color2 = jComponent.getForeground();
        Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 127);
        Color color4 = new Color(247, 247, 247);
        Color color5 = new Color(202, 202, 202);
        if (!buttonModel.isEnabled()) {
            color4 = QDILookAndFeel.wh;
            color5 = QDILookAndFeel.gr;
            color2 = new Color(160, 160, 160);
        }
        if (buttonModel.isEnabled() && buttonModel.isArmed() && buttonModel.isPressed()) {
            paint = color.darker().darker().darker();
            color3 = new Color(((Color)paint).getRed(), ((Color)paint).getGreen(), ((Color)paint).getBlue(), 127);
            color4 = Color.GRAY;
            color5 = Color.WHITE;
        }
        graphics2D2.setColor(color3);
        paint = new GradientPaint(0.0f, 0.0f, color4, 0.0f, jComponent.getHeight(), color5, true);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(1, 1, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        graphics2D.setColor(new Color(144, 144, 144));
        graphics2D.drawRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        graphics2D2.setComposite(AlphaComposite.getInstance(5, 1.0f));
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, jComponent);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(color2);
        graphics2D.drawString(string, (int)rectangle2.getX(), (int)rectangle2.getY() + graphics2D.getFontMetrics().getAscent());
        if (abstractButton.getIcon() != null) {
            abstractButton.getIcon().paintIcon(jComponent, graphics, (int)rectangle3.getX(), (int)rectangle3.getY());
        }
    }
}

